-- On se place dans le contexte de la base DB_MAGIC
USE DB_MAGIC;
GO
-- On cre le schma dans la base pour les donnes claires et cryptes
CREATE SCHEMA S_CRYPTE;
GO
CREATE SCHEMA S_CLAIR;
GO
-- On cre une table de patients
CREATE TABLE S_CRYPTE.T_PATIENT_PTT
(PTT_ID               INT IDENTITY PRIMARY KEY,
 PTT_NOM_CRYPTE       VARBINARY(128),
 PTT_NUMSECU_CRYPTE   VARBINARY(64));
GO
-- On cre une vue de dcryptage des donnes de la table de patients
CREATE VIEW S_CLAIR.V_PATIENT_PTT WITH ENCRYPTION
AS
SELECT PTT_ID,
       CAST(DECRYPTBYPASSPHRASE('18 juin 44',
       PTT_NOM_CRYPTE) AS VARCHAR(32)) AS PTT_NOM,
       CAST(DECRYPTBYPASSPHRASE('18 juin 44',
       PTT_NUMSECU_CRYPTE) AS CHAR(13)) AS PTT_NUMSECU
FROM   S_CRYPTE.T_PATIENT_PTT;
GO
-- On cre un dclencheur pour automatiser linsertion des donnes cryptes
CREATE TRIGGER E_I_V_PTT ON S_CLAIR.V_PATIENT_PTT WITH ENCRYPTION
INSTEAD OF INSERT
AS
BEGIN
INSERT INTO S_CRYPTE.T_PATIENT_PTT
SELECT ENCRYPTBYPASSPHRASE('18 juin 44', PTT_NOM),
       ENCRYPTBYPASSPHRASE('18 juin 44', PTT_NUMSECU)
FROM inserted;
END;
GO
-- On insre des donnes claires dans la vue, elles seront cryptes par le trigger
INSERT INTO S_CLAIR.V_PATIENT_PTT VALUES (NULL, 'De Gaulle', '1234567890123');
GO
-- On visualise les donnes cryptes
SELECT * FROM S_CRYPTE.T_PATIENT_PTT;
-- On visualise les donnes claires
SELECT * FROM S_CLAIR.V_PATIENT_PTT;